# Test Plan

This document outlines a testing strategy for the mailing system, covering unit, feature, and manual testing.

## 1. Unit Tests

Unit tests should focus on isolating and testing individual methods within the `EmailService`.

- **Mocking**: The `Webklex\Client` facade should be mocked to avoid making actual IMAP connections. This allows for predictable test outcomes.
- **Test Scenarios for `EmailService`**:
    - **Connection**: Test that the service attempts to connect with the correct (currently hardcoded) credentials.
    - **Message Fetching**: 
        - Mock the `getFolder` and `getMessages` methods to return a known `MessageCollection`.
        - Verify that `getInboxMessages` returns the expected collection.
    - **Email Sending**:
        - Mock the Symfony Mailer and Transport.
        - Verify that the `sendEmail` method constructs the email with the correct `to`, `subject`, `body`, `from`, and decrypted password.
- **Sample Data**: Use `.eml` file fixtures to create realistic `Webklex\Message` objects for testing parsing logic (e.g., for headers, bodies, and attachments once implemented).
- **Content Testing**:
    - Test with emails containing non-ASCII (UTF-8) characters in the subject and body.
    - Test with emails that have complex MIME structures.
    - If HTML sanitization is added, test that it correctly strips out malicious tags.

## 2. Feature Tests

Feature tests should simulate user interactions by making HTTP requests to the application's endpoints.

- **Test Scenarios for `EmailController`**:
    - **Authentication**: Test that unauthenticated users are redirected from all email routes.
    - **Inbox (`/email/inbox`)**: 
        - Mock the `EmailService` to avoid real IMAP calls.
        - Test that the controller calls `getInboxMessages`.
        - Test that the view is rendered successfully and contains data from the mocked messages (e.g., sender's email, subject).
    - **Compose (`/email/compose`)**: Test that the compose view can be rendered successfully.
    - **Send (`/POST /email/send`)**:
        - Mock the `EmailService`.
        - Send a valid POST request and assert that the `sendEmail` method is called on the service with the correct data.
        - Test validation by sending invalid data (e.g., missing `to` address, invalid email) and assert that the appropriate error messages are returned.

## 3. Manual QA Scenarios

Manual testing is crucial for verifying the user experience and handling real-world IMAP server quirks.

- **Large Mailbox**: Test inbox loading time and memory usage with a mailbox containing thousands of messages.
- **Attachments**: 
    - Test with various attachment types and sizes (e.g., PDF, DOCX, JPG, large ZIP files).
    - Verify that filenames with special characters are handled correctly.
- **Broken/Malformed Content**:
    - Test with poorly formatted HTML emails to see how they render. Check for layout breaks.
    - Test with emails that have non-standard or missing headers.
- **Folder Management**: If folder switching is implemented, test navigating between different folders (Inbox, Sent, Junk, custom folders).
- **IMAP Server Downtime**: Test the application's behavior when the IMAP server is unreachable. Verify that a user-friendly error is displayed.
- **Cross-Browser Testing**: Test the UI in different browsers (Chrome, Firefox, Safari) to ensure consistent rendering.
