<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\AttendanceMergeService;

class AttendanceBuildDaily extends Command
{
    protected $signature = 'attendance:build-daily {from} {to}';
    protected $description = 'Build/refresh merged daily attendance';

    public function handle(AttendanceMergeService $svc)
    {
        $n = $svc->buildDaily($this->argument('from'), $this->argument('to'));
        $this->info("Upserted {$n} daily rows.");
        return self::SUCCESS;
    }
}
