<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Console\Commands\AttendanceBuildDaily;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */

    protected $commands = [
        AttendanceBuildDaily::class,
    ];

    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();
        $schedule->call(function () {
            $to   = now('Africa/Cairo')->toDateString();
            $from = now('Africa/Cairo')->subDays(7)->toDateString();
            Artisan::call('attendance:build-daily', compact('from', 'to'));
        })->dailyAt('02:20')
            ->name('attendance:build-daily:last7')
            ->withoutOverlapping()
            ->onOneServer()
            ->runInBackground();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
