<?php

namespace App\Enums;

enum VacationStatus: string
{
    case PENDING         = 'pending';
    case LEADER_APPROVED = 'leader_approved';
    case HR_APPROVED     = 'hr_approved';
    case LEADER_REJECTED = 'leader_rejected';
    case HR_REJECTED     = 'hr_rejected';
    case CANCELLED       = 'cancelled_by_member';

    public function isFinal(bool $needsHr): bool
    {
        return match ($this) {
            self::HR_APPROVED,
            self::LEADER_REJECTED,
            self::HR_REJECTED,
            self::CANCELLED => true,
            self::LEADER_APPROVED => !$needsHr, // نهائي لو مش محتاج HR
            default => false,
        };
    }
}
