<?php

namespace App\Events;

use App\Models\AttendancePermit;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PermitRequested implements ShouldBroadcast
{
    use Dispatchable, SerializesModels;

    public AttendancePermit $permit;

    /** @var array<int> */
    public array $recipientIds;

    public function __construct(AttendancePermit $permit, array $recipientIds)
    {
        $this->permit = $permit->load(['employee.user', 'type']);
        $this->recipientIds = array_values(array_unique(array_filter($recipientIds)));
    }

    public function broadcastOn(): array
    {
        return array_map(fn($id) => new PrivateChannel('permits.' . $id), $this->recipientIds);
    }

    public function broadcastAs(): string
    {
        return 'PermitRequested';
    }

    public function broadcastWith(): array
    {
        return [
            'permit_id' => $this->permit->id,
            'employee'  => $this->permit->employee->user->name ?? 'موظف غير معروف',
            'type'      => optional($this->permit->type)->name ?? 'غير محدد',
            'start'     => optional($this->permit->start_datetime)?->format('Y-m-d H:i'),
            'end'       => optional($this->permit->end_datetime)?->format('Y-m-d H:i'),
        ];
    }
}
