<?php

namespace App\Events;

use App\Models\AttendancePermit;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PermitStatusChanged implements ShouldBroadcast
{
    use Dispatchable, SerializesModels;

    public function __construct(
        public AttendancePermit $permit,
        public string $status,
        public string $actorName,
        public array $recipientIds
    ) {
        $this->permit->loadMissing(['employee.user', 'type']);
    }

    public function broadcastOn(): array
    {
        return array_map(fn($id) => new PrivateChannel('permits.' . $id), $this->recipientIds);
    }

    public function broadcastAs(): string
    {
        return 'PermitStatusChanged';
    }

    public function broadcastWith(): array
    {
        return [
            'permit_id' => $this->permit->id,
            'status'    => $this->status,
            'actor_name' => $this->actorName,
            'type'      => optional($this->permit->type)->name ?? 'غير محدد',
            'start'     => optional($this->permit->start_datetime)?->format('Y-m-d H:i'),
            'end'       => optional($this->permit->end_datetime)?->format('Y-m-d H:i'),
        ];
    }
}
