<?php

namespace App\Events;

use App\Models\Vacation;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class VacationRequested implements ShouldBroadcast
{
    use Dispatchable, SerializesModels;

    public Vacation $vacation;

    /** @var array<int> */
    public array $recipientIds;

    public function __construct(Vacation $vacation, array $recipientIds)
    {
        // مهم: نحمّل العلاقات الضرورية للـ payload
        $this->vacation = $vacation->load(['employee.user', 'type']);
        $this->recipientIds = array_values(array_unique(array_filter($recipientIds)));
    }

    /** @return Channel[] */
    public function broadcastOn(): array
    {
        // قناة خاصة لكل مستقبِل
        return array_map(
            fn($id) => new PrivateChannel('vacations.' . $id),
            $this->recipientIds
        );
    }

    public function broadcastAs(): string
    {
        return 'VacationRequested';
    }

    public function broadcastWith(): array
    {
        return [
            'vacation_id' => $this->vacation->id,
            'employee'    => $this->vacation->employee->user->name ?? 'موظف غير معروف',
            'type'        => optional($this->vacation->type)->name ?? 'غير محدد',
            'start'       => $this->vacation->start_date?->format('Y-m-d'),
            'end'         => $this->vacation->end_date?->format('Y-m-d'),
        ];
    }
}
