<?php

namespace App\Events;

use App\Models\Vacation;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class VacationStatusChanged implements ShouldBroadcast
{
    use Dispatchable, SerializesModels;

    public function __construct(
        public Vacation $vacation,
        public string $status,           // approved | rejected | hr_approved | hr_rejected | etc.
        public string $actorName,        // مين اللي عمل الاكشن
        public array  $recipientIds      // نفس فكرة تعدد المستلمين
    ) {
        $this->vacation->loadMissing(['employee.user', 'type']);
    }

    public function broadcastOn(): array
    {
        return array_map(
            fn($id) => new PrivateChannel('vacations.' . $id),
            $this->recipientIds
        );
    }

    public function broadcastAs(): string
    {
        return 'VacationStatusChanged';
    }

    public function broadcastWith(): array
    {
        return [
            'vacation_id' => $this->vacation->id,
            'status'      => $this->status,
            'actor_name'  => $this->actorName,
            'type'        => optional($this->vacation->type)->name ?? 'غير محدد',
            'start'       => $this->vacation->start_date?->format('Y-m-d'),
            'end'         => $this->vacation->end_date?->format('Y-m-d'),
        ];
    }
}
