<?php

namespace App\Http\Controllers\Api\BRNC;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Brnc\StoreContactRequest;
use App\Models\Contact;
use App\Models\LandingFormTracking;
use App\Services\TrackingService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

/**
 * Class ContactController
 *
 * Handles public contact form submissions and persists full tracking data.
 * Maps incoming request keys to landing_form_tracking schema.
 */
class ContactController extends Controller
{
    /**
     * Store a new contact form submission with tracking data.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(StoreContactRequest $request): JsonResponse
    {
        Contact::create([
            'action_time'       => $request->input('action_time'),
            'session_started_at'=> $request->input('session_started_at'),

            'geo_ip'            => $request->input('geo.ip'),
            'geo_country'       => $request->input('geo.country'),
            'geo_city'          => $request->input('geo.city'),
            'geo_region'        => $request->input('geo.region'),
            'geo_lat'           => $request->input('geo.lat'),
            'geo_lon'           => $request->input('geo.lon'),
            'geo_source'        => $request->input('geo.source'),

            'platform'          => $request->input('platform'),
            'user_agent_sample' => $request->input('user_agent_sample'),

            'user_name'         => $request->input('data.name'),
            'user_email'        => $request->input('data.email'),
            'user_mobile'       => $request->input('data.mobile'),
            'user_services'     => $request->input('data.services'),
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Contact form submitted with tracking.',
        ]);
    }
}
