<?php

namespace App\Http\Controllers\Api\BRNC;

use App\Http\Controllers\Controller;
use App\Models\LandingFormTracking;
use Illuminate\Http\Request;

class ContactFormController extends Controller {
    public function store(Request $request) {
        $validated = $request->validate([
            'name' => 'required|string|max:44',
            'mobile' => 'required|string|max:21',
            'address' => 'required',
            'services' => 'required',
            'account_name' => 'required|string|max:21',
            'platform_info' => 'required|string|max:21',
            'platform_ip' => 'nullable|string|max:41',
            'ip_lat' => 'nullable|string|max:21',
            'ip_lng' => 'nullable|string|max:21',
            'ip_country' => 'nullable|string|max:21',
            'ip_city' => 'nullable|string|max:21',
            'ip_region' => 'nullable|string|max:44',
        ]);

        $data = array_merge($validated, [
            'platform_ip_2' => $request->server('REMOTE_HOST') ?? gethostbyaddr($request->server('REMOTE_ADDR')),
        ]);

        LandingFormTracking::create($data);

        // Email
        // Mail::to('onlineinstitutega@gmail.com')->send(new ContactMail($data));

        return redirect()->back()->with('success', 'Record created and mail sent!');
    }
}
