<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\MediaLink;
use Illuminate\Http\Request;

class MediaLinkController extends Controller
{
    public function getMediaLink(Request $request)
    {
        $request->validate([
            'subdomain' => 'required|string|exists:media_links,domain',
        ]);

        $subdomain = $request->subdomain;


        // $url = request()->url();
        // $domain = parse_url($url, PHP_URL_HOST);
        // $subdomain = explode('.', $domain)[0];

        $mediaLink = MediaLink::where('domain', $subdomain)->first();

        if (!$mediaLink) {
            return response()->json(['message' => 'Media link not found'], 404);
        }

        $response = [
            'defaultLanguage' => $mediaLink->default_language ?? 'en',
            'en' => [
                'logo' => $mediaLink->en_logo ?? '',
                'title' => $mediaLink->en_title ?? '',
                'colors' => [
                    'primary' => $mediaLink->en_colors['primary'] ?? '',
                    'secodary' => $mediaLink->en_colors['secodary'] ?? '',
                    'social_link' => $mediaLink->en_colors['social_link'] ?? '',
                    'social_link_text' => $mediaLink->en_colors['social_link_text'] ?? '',
                    'card' => $mediaLink->en_colors['card'] ?? '',
                    'btn' => [
                        'text' => $mediaLink->en_colors['btn']['text'] ?? '',
                        'background' => $mediaLink->en_colors['btn']['background'] ?? '',
                        'hover' => $mediaLink->en_colors['btn']['hover'] ?? '',
                        'focus' => $mediaLink->en_colors['btn']['focus'] ?? '',
                    ],
                    'footer' => $mediaLink->en_colors['footer'] ?? '',
                    'background-OfficalWebsite' => $mediaLink->en_colors['background-OfficalWebsite'] ?? '',
                    'text-OfficalWebsite' => $mediaLink->en_colors['text-OfficalWebsite'] ?? '',
                ],
                'socialMediaLinks' => [
                    [
                        'label' => 'Facebook',
                        'link' => $mediaLink->en_social_media_links[0]['link'] ?? 'https://',
                    ],
                    [
                        'label' => 'Instagram',
                        'link' => $mediaLink->en_social_media_links[1]['link'] ?? 'https://',
                    ],
                    [
                        'label' => 'Snapchat',
                        'link' => $mediaLink->en_social_media_links[2]['link'] ?? 'https://',
                    ],
                    [
                        'label' => 'TikTok',
                        'link' => $mediaLink->en_social_media_links[3]['link'] ?? 'https://',
                    ],
                    [
                        'label' => 'Offical Website',
                        'link' => $mediaLink->en_social_media_links[4]['link'] ?? 'Coming Soon, Stay tuned!',
                    ],
                ],
                'contact' => [
                    'callNumber' => $mediaLink->en_contact['callNumber'] ?? '',
                    'whatsAppNumber' => $mediaLink->en_contact['whatsAppNumber'] ?? '',
                ],
                'qrCode' => $mediaLink->en_qr_code ?? 'http://',
            ],
            'ar' => [
                'logo' => $mediaLink->ar_logo ?? '',
                'title' => $mediaLink->ar_title ?? '',
                'colors' => [
                    'primary' => $mediaLink->ar_colors['primary'] ?? '',
                    'secodary' => $mediaLink->ar_colors['secodary'] ?? '',
                    'social_link' => $mediaLink->ar_colors['social_link'] ?? '',
                    'social_link_text' => $mediaLink->ar_colors['social_link_text'] ?? '',
                    'card' => $mediaLink->ar_colors['card'] ?? '',
                    'btn' => [
                        'text' => $mediaLink->ar_colors['btn']['text'] ?? '',
                        'background' => $mediaLink->ar_colors['btn']['background'] ?? '',
                        'hover' => $mediaLink->ar_colors['btn']['hover'] ?? '',
                        'focus' => $mediaLink->ar_colors['btn']['focus'] ?? '',
                    ],
                    'footer' => $mediaLink->ar_colors['footer'] ?? '',
                    'background-OfficalWebsite' => $mediaLink->ar_colors['background-OfficalWebsite'] ?? '',
                    'text-OfficalWebsite' => $mediaLink->ar_colors['text-OfficalWebsite'] ?? '',
                ],
                'socialMediaLinks' => [
                    [
                        'label' => 'فيس بوك',
                        'link' => $mediaLink->ar_social_media_links[0]['link'] ?? 'https://',
                    ],
                    [
                        'label' => 'انستجرام',
                        'link' => $mediaLink->ar_social_media_links[1]['link'] ?? 'https://',
                    ],
                    [
                        'label' => 'سناب شات',
                        'link' => $mediaLink->ar_social_media_links[2]['link'] ?? 'https://',
                    ],
                    [
                        'label' => 'تيك توك',
                        'link' => $mediaLink->ar_social_media_links[3]['link'] ?? 'https://',
                    ],
                    [
                        'label' => 'الموقع الالكتروني',
                        'link' => $mediaLink->ar_social_media_links[4]['link'] ?? '!انتظرونا، قريباً',
                    ],
                ],
                'contact' => [
                    'callNumber' => $mediaLink->ar_contact['callNumber'] ?? '',
                    'whatsAppNumber' => $mediaLink->ar_contact['whatsAppNumber'] ?? '',
                ],
                'qrCode' => $mediaLink->ar_qr_code ?? 'http://',
            ],
        ];

        return response()->json($response);
    }
}
