<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Department;
use App\Models\Employee;
use Illuminate\Http\Request;

class OrgApiController extends Controller
{
    public function tree(Request $r)
    {
        $all = Department::withCount('employees')
            ->orderBy('parent_id')
            ->orderBy('name')
            ->get(['id','name','parent_id','code','color_code']);

        $byParent = $all->groupBy('parent_id');

        $build = function($parentId) use (&$build, $byParent) {
            return ($byParent[$parentId] ?? collect())->map(function ($d) use (&$build) {
                return [
                    'id' => $d->id,
                    'name' => $d->name,
                    'code' => $d->code,
                    'color' => $d->color_code,
                    'employees_count' => (int) $d->employees_count,
                    'children' => $build($d->id),
                ];
            })->values();
        };

        return response()->json([
            'roots' => $build(null),
            'total' => $all->count(),
        ]);
    }

    public function employees(Department $department, Request $r)
    {
        $per = (int) $r->integer('per_page', 12);

        $q = Employee::with([
                'user:id,name,email',
                'department:id,name',
            ])->where('department_id', $department->id)
              ->orderByDesc('id');

        if ($search = trim((string) $r->query('q', ''))) {
            $q->where(function($w) use ($search) {
                $w->where('first_name','like',"%$search%")
                  ->orWhere('last_name','like',"%$search%")
                  ->orWhere('employee_code','like',"%$search%");
            });
        }

        $p = $q->paginate($per);

        // return response()->json([
        //     'data' => $p->map(function($e) {
        //         return [
        //             'id' => $e->id,
        //             'name' => trim($e->first_name.' '.$e->last_name),
        //             'user_email' => optional($e->user)->email,
        //             'dept' => optional($e->department)->name,
        //             'status' => $e->status,
        //         ];
        //     }),
        //     'meta' => [
        //         'current_page' => $p->currentPage(),
        //         'last_page'    => $p->lastPage(),
        //         'per_page'     => $p->perPage(),
        //         'total'        => $p->total(),
        //     ]
        // ]);

return response()->json([
  'data' => $p->map(function($e){
    return [
      'id' => $e->id,
      'first_name'    => $e->first_name,
      'last_name'     => $e->last_name,
      'name'          => trim($e->first_name.' '.$e->last_name),
      'user_id'       => $e->user_id,
      'user_email'    => optional($e->user)->email,
      'dept'          => optional($e->department)->name,
      'department_id' => $e->department_id,
      'status'        => $e->status,
    ];
  }),
  'meta' => [ /* as-is */ ]
]);


    }
}
