<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Quotation;
use Illuminate\Http\Request;

class QuotationController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'subdomain' => 'required|string|max:255',
            'type' => 'required|string|in:shopify,landing,salla,website,woocommerce|max:255',
            'json_data' => 'required|array',
        ]);

        $subdomain = $request->subdomain;
        $type = $request->type;
        $jsonData = $request->json_data;

        Quotation::create([
            'subdomain' => $subdomain,
            'type' => Quotation::QuotationType[strtoupper($type)],
            'json_data' => $jsonData,
        ]);

        return response()->json([
            'message' => $type . ' Quotation created successfully'
        ], 201);
    }

    public function get(Request $request)
    {
        $request->validate([
            'subdomain' => 'required|string|exists:quotations,subdomain',
        ]);

        $subdomain = $request->subdomain;

        $quotation = Quotation::where('subdomain', $subdomain)->first();

        if (!$quotation) {
            return response()->json(['message' => 'Quotation not found'], 404);
        }

        return response()->json($quotation);
    }
}
