<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Team;
use App\Services\TeamService;
use Illuminate\Http\Request;

class TeamController extends Controller
{
    protected $teamService;

    public function __construct(TeamService $teamService)
    {
        $this->teamService = $teamService;
    }

    public function index()
    {
        return response()->json($this->teamService->getAllTeams());
    }

    public function store(Request $request)
    {
        $team = $this->teamService->createTeam($request->all());
        return response()->json($team, 201);
    }

    public function show(int $id)
    {
        return response()->json($this->teamService->getTeamById($id));
    }

    public function update(Request $request, Team $team)
    {
        $team = $this->teamService->updateTeam($team, $request->all());
        return response()->json($team);
    }

    public function destroy(Team $team)
    {
        $this->teamService->deleteTeam($team);
        return response()->json(null, 204);
    }

    public function attachMember(Request $request, Team $team)
    {
        $this->teamService->attachMember($team, $request->team_member_id, $request->except('team_member_id'));
        return response()->json(['message' => 'Member attached successfully']);
    }

    public function detachMember(Request $request, Team $team)
    {
        $this->teamService->detachMember($team, $request->team_member_id);
        return response()->json(['message' => 'Member detached successfully']);
    }
}
