<?php
declare(strict_types=1);

namespace App\Http\Controllers;

use App\Services\DnsHealthService;
use Illuminate\Http\Request;

class DnsHealthController extends Controller
{
    public function __construct() {
        $this->middleware('auth');
    }

    /** GET /email/tools/dns */
    public function index(Request $r, DnsHealthService $svc) {
        // Defaults from config/env: mail host ثم استخراج الدومين
        $defaultMailHost = (string) (config('mail.mailers.smtp.host') ?: env('MAIL_HOST') ?: env('IMAP_HOST', ''));
        $defaultDomain   = $svc->baseDomainFromMailHost($defaultMailHost);

        $domain   = $r->query('domain', $defaultDomain);
        $mailHost = $r->query('mail_host', $defaultMailHost);

        $report = $svc->run($domain, $mailHost);

        return view('email.tools.dns-health', [
            'report'     => $report,
            'domain'     => $domain,
            'mailHost'   => $mailHost,
        ]);
    }
}
