<?php

namespace App\Http\Controllers;

use App\Services\HomeAttendanceService;
use App\Services\AttendanceMergeService;
use Illuminate\Http\Request;

class HomeAttendanceController extends Controller
{
    public function __construct(
        private HomeAttendanceService $home,
        private AttendanceMergeService $merge
    ) {}

    public function checkIn(Request $r)
    {
        // لو عايز باسورد: اتأكد في ميدل وير أو هنا قبل الاستدعاء
        $res = $this->home->checkIn();
        if (!$res['ok']) return response()->json($res, 422);

        // تحديث daily لليوم الحالي
        $this->merge->refreshDay(auth()->user()->employee->employee_code, now('Africa/Cairo')->toDateString());

        return response()->json($res);
    }

    public function checkOut(Request $r)
    {
        $res = $this->home->checkOut();
        if (!$res['ok']) return response()->json($res, 422);

        $this->merge->refreshDay(auth()->user()->employee->employee_code, now('Africa/Cairo')->toDateString());

        return response()->json($res);
    }
}
