<?php
declare(strict_types=1);

namespace App\Http\Controllers;

use App\Services\MailDiagnostics;
use App\Services\EmailService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

/**
 * Class MailHealthController
 *
 * Renders a checklist page for IMAP/SMTP health and offers a "Send Test Email".
 */
class MailHealthController extends Controller
{
    public function __construct() {
        $this->middleware('auth');
    }

    /** GET /email/tools/health */
    public function index(MailDiagnostics $diag) {
        $report = $diag->run();
        return view('email.tools.mail-health', [
            'report' => $report,
            'me'     => Auth::user(),
        ]);
    }

    /** POST /email/tools/health/send-test */
    public function sendTest(Request $r, EmailService $mail) {
    $data = $r->validate([
        'to'      => ['required','email'],
        'subject' => ['nullable','string'],
        'body'    => ['nullable','string'],
    ]);

    $subject = $data['subject'] ?? ('SMTP Test - '.now()->format('Y-m-d H:i:s'));
    $body    = $data['body']    ?? '<p>This is a test email sent by Mail Health page.</p>';

    // إرسال فعلي (EmailService عندك بيدعّم المرفقات، فإحنا مش بنبعتها هنا)
    $mail->sendEmail($data['to'], $subject, $body, null, null, null);

    return back()->with('ok', 'Test email sent to '.$data['to']);
}
}
