<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Department;
use App\Models\Employee;
use Illuminate\Http\Request;

class OrgDirectoryController extends Controller
{
    public function index(Request $request)
    {
      $selectedId = (int) $request->input('department_id');

        // شجرة الأقسام + عداد الموظفين (بدون N+1)
        $departments = Department::with([
            'children:id,parent_id,name',
            'parent:id,name',
        ])->withCount('employees')
          ->orderBy('name')
          ->get(['id','name','parent_id']);

        // لو القسم متحدد هات موظفيه، وإلا أول قسم أبجدي (إن وُجد)
        if (!$selectedId && $departments->count()) {
            $selectedId = (int) $departments->first()->id;
        }

        $employees = Employee::with([
                'user:id,name,email',
                'department:id,name',
            ])
            ->when($selectedId, fn ($q) => $q->where('department_id', $selectedId))
            ->orderBy('id','desc')
            ->paginate(15);

        return view('pages.departments-teams.index', [
            'departments' => $departments,
            'employees'   => $employees,
            'selectedId'  => $selectedId,
        ]);
    }
}
