<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Http\Requests\Web\StoreMediaLinkRequest;
use App\Models\MediaLink;
use Illuminate\Support\Facades\Http;

class MediaLinkController extends Controller
{
    public function store(StoreMediaLinkRequest $request)
    {
        $validated = $request->validated();

        $subdomain = $validated['subdomain'];
        // $rootDomain = env('ROOT_DOMAIN');
        // $documentRoot = "/home/mediafactoryworld/public_html/$subdomain";
        // $cpanelUser = env('CPANEL_USERNAME');
        // $cpanelHost = env('CPANEL_HOST');
        // $apiToken = env('CPANEL_API_TOKEN');

        // // $url = "https://{$cpanelHost}:2083/json-api/cpanel?cpanel_jsonapi_user={$cpanelUser}&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=SubDomain&cpanel_jsonapi_func=addsubdomain&domain={$subdomain}&rootdomain={$rootDomain}&dir={$documentRoot}";
        // $url = "https://{$cpanelHost}:2083/json-api/cpanel?cpanel_jsonapi_user={$cpanelUser}&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=SubDomain&cpanel_jsonapi_func=listsubdomains";
        // \Log::info('cPanel API Request URL: ' . $url);
        // \Log::info('cPanel Authorization Header: ' . "cpanel {$cpanelUser}:{$apiToken}");

        // try {
        //     $response = Http::withHeaders([
        //         'Authorization' => "cpanel {$cpanelUser}:{$apiToken}",
        //     ])->withoutVerifying()->timeout(30)->get($url);


        //     \Log::info('cPanel API Response Status: ' . $response->status());
        //     \Log::info('cPanel API Response Body: ' . $response->body());

        //     if ($response->successful()) {
        //         $result = $response->json();
        //         if ($result['cpanelresult']['data']['result'] == 1) {
        //             return response()->json([
        //                 'status' => 'success',
        //                 'message' => "Subdomain {$subdomain}.{$rootDomain} created successfully!"
        //             ], 200);
        //         } else {
        //             return response()->json([
        //                 'status' => 'error',
        //                 'message' => 'Error: ' . $result['cpanelresult']['data']['reason']
        //             ], 400);
        //         }
        //     } else {
        //         return response()->json([
        //             'status' => 'error',
        //             'message' => 'Failed to connect to cPanel API: ' . $response->status(),
        //             'response_body' => $response->body() // Include the response body for debugging
        //         ], 500);
        //     }
        // } catch (\Exception $e) {
        //     \Log::error('cPanel API Exception: ' . $e->getMessage());
        //     return response()->json([
        //         'status' => 'error',
        //         'message' => 'An error occurred: ' . $e->getMessage()
        //     ], 500);
        // }

        $data = [
            'domain' => $validated['subdomain'],
            'default_language' => $validated['defaultLanguage'],

            // English data
            'en_logo' => $validated['en']['logo'] ?? null,
            'en_title' => $validated['en']['title'] ?? null,
            'en_colors' => [
                'primary' => $validated['en']['colors']['primary'] ?? null,
                'secodary' => $validated['en']['colors']['secodary'] ?? null,
                'social_link' => $validated['en']['colors']['social_link'] ?? null,
                'social_link_text' => $validated['en']['colors']['social_link_text'] ?? null,
                'card' => $validated['en']['colors']['card'] ?? null,
                'btn' => [
                    'text' => $validated['en']['colors']['btn']['text'] ?? null,
                    'background' => $validated['en']['colors']['btn']['background'] ?? null,
                    'hover' => $validated['en']['colors']['btn']['hover'] ?? null,
                    'focus' => $validated['en']['colors']['btn']['focus'] ?? null,
                ],
                'footer' => $validated['en']['colors']['footer'] ?? null,
                'background-OfficalWebsite' => $validated['en']['colors']['background-OfficalWebsite'] ?? null,
                'text-OfficalWebsite' => $validated['en']['colors']['text-OfficalWebsite'] ?? null,
            ],
            'en_social_media_links' => [
                ['label' => 'Facebook', 'link' => $validated['en']['socialMediaLinks']['facebook'] ?? null],
                ['label' => 'Instagram', 'link' => $validated['en']['socialMediaLinks']['instagram'] ?? null],
                ['label' => 'Snapchat', 'link' => $validated['en']['socialMediaLinks']['snapchat'] ?? null],
                ['label' => 'TikTok', 'link' => $validated['en']['socialMediaLinks']['tiktok'] ?? null],
                ['label' => 'Offical Website', 'link' => $validated['en']['socialMediaLinks']['website'] ?? null],
            ],
            'en_contact' => [
                'callNumber' => $validated['en']['contact']['callNumber'] ?? null,
                'whatsAppNumber' => $validated['en']['contact']['whatsAppNumber'] ?? null,
            ],
            'en_qr_code' => $validated['en']['qrCode'] ?? null,

            // Arabic data
            'ar_logo' => $validated['ar']['logo'] ?? null,
            'ar_title' => $validated['ar']['title'] ?? null,
            'ar_colors' => [
                'primary' => $validated['ar']['colors']['primary'] ?? null,
                'secodary' => $validated['ar']['colors']['secodary'] ?? null,
                'social_link' => $validated['ar']['colors']['social_link'] ?? null,
                'social_link_text' => $validated['ar']['colors']['social_link_text'] ?? null,
                'card' => $validated['ar']['colors']['card'] ?? null,
                'btn' => [
                    'text' => $validated['ar']['colors']['btn']['text'] ?? null,
                    'background' => $validated['ar']['colors']['btn']['background'] ?? null,
                    'hover' => $validated['ar']['colors']['btn']['hover'] ?? null,
                    'focus' => $validated['ar']['colors']['btn']['focus'] ?? null,
                ],
                'footer' => $validated['ar']['colors']['footer'] ?? null,
                'background-OfficalWebsite' => $validated['ar']['colors']['background-OfficalWebsite'] ?? null,
                'text-OfficalWebsite' => $validated['ar']['colors']['text-OfficalWebsite'] ?? null,
            ],
            'ar_social_media_links' => [
                ['label' => 'فيس بوك', 'link' => $validated['ar']['socialMediaLinks']['facebook'] ?? null],
                ['label' => 'انستجرام', 'link' => $validated['ar']['socialMediaLinks']['instagram'] ?? null],
                ['label' => 'سناب شات', 'link' => $validated['ar']['socialMediaLinks']['snapchat'] ?? null],
                ['label' => 'تيك توك', 'link' => $validated['ar']['socialMediaLinks']['tiktok'] ?? null],
                ['label' => 'الموقع الالكتروني', 'link' => $validated['ar']['socialMediaLinks']['website'] ?? null],
            ],
            'ar_contact' => [
                'callNumber' => $validated['ar']['contact']['callNumber'] ?? null,
                'whatsAppNumber' => $validated['ar']['contact']['whatsAppNumber'] ?? null,
            ],
            'ar_qr_code' => $validated['ar']['qrCode'] ?? null,
        ];

        $mediaLink = MediaLink::create($data);

        return response()->json([
            'message' => 'Media link created successfully',
            'data' => $mediaLink
        ], 201);
    }
}
