<?php

namespace App\Http\Controllers;

use App\Models\Department;
use App\Models\TeamMember;
use Illuminate\Http\Request;
use App\Http\Requests\Department\StoreDepartmentRequest;
use App\Http\Requests\Department\UpdateDepartmentRequest;
use App\Http\Requests\TeamMember\StoreTeamMemberRequest;
use App\Http\Requests\TeamMember\UpdateTeamMemberRequest;

class DepartmentsTeamsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $departments = Department::with(['parent', 'children' ])->get();
        return view('pages.departments-teams.index', compact('departments'));
    }

    public function storeDepartment(StoreDepartmentRequest $request)
    {
        $department = Department::create($request->validated());
        return back()->with('success', 'Department created successfully');
    }

    public function updateDepartment(UpdateDepartmentRequest $request, Department $department)
    {
        $department->update($request->validated());
        return back()->with('success', 'Department updated successfully');
    }

    public function destroyDepartment(Department $department)
    {
        if ($department->children()->exists()) {
            return back()->with('error', 'Cannot delete department with child departments');
        }

        $department->delete();
        return back()->with('success', 'Department deleted successfully');
    }

    public function storeTeamMember(StoreTeamMemberRequest $request)
    {
        TeamMember::create($request->validated());
        return back()->with('success', 'Team member created successfully');
    }

    public function updateTeamMember(UpdateTeamMemberRequest $request, TeamMember $teamMember)
    {
        $teamMember->update($request->validated());
        return back()->with('success', 'Team member updated successfully');
    }

    public function destroyTeamMember(TeamMember $teamMember)
    {
        $teamMember->delete();
        return back()->with('success', 'Team member deleted successfully');
    }
}
