<?php

namespace App\Http\Requests\Api\Brnc;

use Illuminate\Foundation\Http\FormRequest;

class StoreContactRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'action_time' => 'required|date|date_format:Y-m-d\TH:i:s.v\Z',
            'session_started_at' => 'required|date|date_format:Y-m-d\TH:i:s.v\Z',

            // Geo validation
            'geo' => 'required|array',
            'geo.ip' => 'required|ip',
            'geo.country' => 'required|string|max:100',
            'geo.city' => 'required|string|max:100',
            'geo.region' => 'required|string|max:100',
            'geo.lat' => 'required|numeric|between:-90,90',
            'geo.lon' => 'required|numeric|between:-180,180',
            'geo.source' => 'required|string|max:50',

            // Platform and user agent
            'platform' => 'required|string|in:instagram,facebook,twitter,youtube,tiktok,linkedin,other',
            'user_agent_sample' => 'required|string|max:500',

            // Data validation
            'data' => 'required|array',
            'data.name' => 'required|string|min:2|max:100',
            'data.email' => 'required|email|max:255',
            'data.mobile' => 'required|string|regex:/^[0-9+\-\s()]{10,20}$/',
            'data.services' => 'required|string|max:100',
        ];
    }

    /**
     * Get custom error messages for validation rules.
     */
    public function messages(): array
    {
        return [
            'action_time.date_format' => 'The action time must be in ISO 8601 format with milliseconds.',
            'sessoion_started_at.date_format' => 'The session started time must be in ISO 8601 format with milliseconds.',
            'geo.ip.ip' => 'The IP address must be a valid IP address.',
            'geo.lat.between' => 'The latitude must be between -90 and 90 degrees.',
            'geo.lon.between' => 'The longitude must be between -180 and 180 degrees.',
            'platform.in' => 'The platform must be one of: instagram, facebook, twitter, youtube, tiktok, linkedin, other.',
            'data.mobile.regex' => 'The mobile number format is invalid.',
        ];
    }

    /**
     * Get custom attribute names for error messages.
     */
    public function attributes(): array
    {
        return [
            'action_time' => 'action time',
            'sessoion_started_at' => 'session started time',
            'geo.ip' => 'IP address',
            'geo.country' => 'country',
            'geo.city' => 'city',
            'geo.region' => 'region',
            'geo.lat' => 'latitude',
            'geo.lon' => 'longitude',
            'geo.source' => 'geo source',
            'user_agent_sample' => 'user agent',
            'data.name' => 'name',
            'data.email' => 'email',
            'data.mobile' => 'mobile number',
            'data.services' => 'services',
        ];
    }
}
