<?php

namespace App\Http\Requests\Department;
// app/Http/Requests/Department/StoreDepartmentRequest.php


use Illuminate\Foundation\Http\FormRequest;

class StoreDepartmentRequest extends FormRequest
{
    public function authorize(): bool { return true; }
    public function rules(): array {
        return [
            'name'       => ['required','string','max:255'],
            'code'       => ['nullable','string','max:50','unique:departments,code'],
            'parent_id'  => ['nullable','exists:departments,id'],
            'manager_id' => ['nullable','exists:employees,id'],
            'color_code' => ['nullable','regex:/^#?[0-9a-fA-F]{6}$/'],
            'is_active'  => ['nullable','boolean'],
        ];
    }
}
