<?php

namespace App\Http\Requests\Department;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;


class UpdateDepartmentRequest extends FormRequest
{
    public function authorize(): bool { return true; }
    public function rules(): array {
        $id = $this->route('dept')->id ?? null;
        return [
            'name'       => ['sometimes','string','max:255'],
            'code'       => ['sometimes','nullable','string','max:50', Rule::unique('departments','code')->ignore($id)],
            'parent_id'  => ['sometimes','nullable','exists:departments,id'],
            'manager_id' => ['sometimes','nullable','exists:employees,id'],
            'color_code' => ['sometimes','nullable','regex:/^#?[0-9a-fA-F]{6}$/'],
            'is_active'  => ['sometimes','boolean'],
        ];
    }
}
