<?php


namespace App\Http\Requests\Employee;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreEmployeeRequest extends FormRequest
{
    public function authorize(): bool { return true; }
    public function rules(): array {
        return [
            'employee_code' => [
                'required','string','max:255',
                Rule::unique('employees')->where(fn($q) => $q->where('branch_id', $this->branch_id)),
            ],
            'branch_id'     => ['required','integer'],
            'user_id'       => ['nullable','exists:users,id'],
            'department_id' => ['required','exists:departments,id'],
            'first_name'    => ['required','string','max:255'],
            'last_name'     => ['required','string','max:255'],
            'hire_date'     => ['nullable','date'],
            'status'        => ['required','in:active,inactive,on_leave'],
        ];
    }
}
