<?php

namespace App\Http\Requests\Employee;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateEmployeeRequest extends FormRequest
{
    public function authorize(): bool { return true; }
    public function rules(): array {
        $id = $this->route('employee')->id ?? null;

        return [
            'employee_code' => [
                'sometimes','string','max:255',
                Rule::unique('employees')->where(fn($q) => $q->where('branch_id', $this->branch_id))->ignore($id),
            ],
            'branch_id'     => ['sometimes','integer'],
            'user_id'       => ['sometimes','nullable','exists:users,id'],
            'department_id' => ['sometimes','exists:departments,id'],
            'first_name'    => ['sometimes','string','max:255'],
            'last_name'     => ['sometimes','string','max:255'],
            'hire_date'     => ['sometimes','nullable','date'],
            'status'        => ['sometimes','in:active,inactive,on_leave'],
        ];
    }
}
