<?php

namespace App\Http\Requests\Vacation;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Vacation;

class StoreVacationRequest extends FormRequest
{
       public function authorize(): bool { return auth()->check(); }

    // public function authorize(): bool { return $this->user()?->can('create', Vacation::class) ?? true; }

    public function rules(): array {
        return [
            'vacation_type_id' => ['required','exists:vacation_types,id'],
            'start_date'       => ['required','date'],
            'end_date'         => ['required','date','after_or_equal:start_date'],
            'member_reason'    => ['nullable','string','max:2000'],
        ];
    }
}
