<?php

namespace App\Http\Requests\Vacation;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Vacation;

class UpdateVacationRequest extends FormRequest
{
    public function authorize(): bool
    {
        /** @var \App\Models\Vacation $vacation */
        $vacation = $this->route('vacation');
        return $this->user()?->can('update', $vacation) ?? false;
    }

    public function rules(): array
    {
        return [
            'vacation_type_id' => ['required','exists:vacation_types,id'],
            'start_date'       => ['required','date','before_or_equal:end_date'],
            'end_date'         => ['required','date','after_or_equal:start_date'],
            'member_reason'    => ['nullable','string','max:2000'],
        ];
    }
}
