<?php

namespace App\Http\Requests\Web;

use Illuminate\Foundation\Http\FormRequest;

class StoreMediaLinkRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'subdomain' => 'required|alpha_dash|max:50',
            'defaultLanguage' => 'required|string|in:en,ar',

            // English Section
            'en.logo' => 'nullable|string|max:255',
            'en.title' => 'nullable|string|max:100',

            // Colors (hex code validation)
            'en.colors.primary' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.secodary' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.social_link' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.social_link_text' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.card' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.btn.text' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.btn.background' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.btn.hover' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.btn.focus' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.footer' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.background-OfficalWebsite' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'en.colors.text-OfficalWebsite' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],

            // Social Media Links
            'en.socialMediaLinks.facebook' => 'nullable|url|max:255',
            'en.socialMediaLinks.instagram' => 'nullable|url|max:255',
            'en.socialMediaLinks.snapchat' => 'nullable|url|max:255',
            'en.socialMediaLinks.tiktok' => 'nullable|url|max:255',
            'en.socialMediaLinks.website' => 'nullable|string|max:255',

            // Contact (phone number validation)
            'en.contact.callNumber' => ['nullable', 'string', 'regex:/^\+?[1-9]\d{1,14}$/'],
            'en.contact.whatsAppNumber' => ['nullable', 'string', 'regex:/^\+?[1-9]\d{1,14}$/'],

            'en.qrCode' => 'nullable|url|max:255',

            // Arabic Section
            'ar.logo' => 'nullable|string|max:255',
            'ar.title' => 'nullable|string|max:100',

            // Colors (hex code validation)
            'ar.colors.primary' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.secodary' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.social_link' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.social_link_text' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.card' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.btn.text' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.btn.background' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.btn.hover' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.btn.focus' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.footer' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.background-OfficalWebsite' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],
            'ar.colors.text-OfficalWebsite' => ['nullable', 'string', 'regex:/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/'],

            // Social Media Links
            'ar.socialMediaLinks.facebook' => 'nullable|url|max:255',
            'ar.socialMediaLinks.instagram' => 'nullable|url|max:255',
            'ar.socialMediaLinks.snapchat' => 'nullable|url|max:255',
            'ar.socialMediaLinks.tiktok' => 'nullable|url|max:255',
            'ar.socialMediaLinks.website' => 'nullable|string|max:255',

            // Contact (phone number validation)
            'ar.contact.callNumber' => ['nullable', 'string', 'regex:/^\+?[1-9]\d{1,14}$/'],
            'ar.contact.whatsAppNumber' => ['nullable', 'string', 'regex:/^\+?[1-9]\d{1,14}$/'],

            'ar.qrCode' => 'nullable|url|max:255',
        ];
    }

    public function messages(): array
    {
        return [
            'regex' => 'The :attribute must be a valid hex color code (e.g., #FF0000) or phone number.',
            'url' => 'The :attribute must be a valid URL.',
            'max' => 'The :attribute may not be greater than :max characters.',
            'in' => 'The :attribute must be either "en" or "ar".',
            'required' => 'The :attribute field is required.',
        ];
    }
}
