<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DepartmentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'color_code' => $this->color_code,
            'parent_id' => $this->parent_id,
            'parent' => $this->when($this->parent, new DepartmentResource($this->parent)),
            'children' => DepartmentResource::collection($this->whenLoaded('children')),
            'team_members' => TeamMemberResource::collection($this->whenLoaded('teamMembers')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
