<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AttendanceLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_code',
        'check_time',
        'branch_id',
        'type',
        'source',
        'employee_name',
        'branch_name'
    ];

    protected $casts = [
        'check_time' => 'datetime',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class, ['employee_code', 'branch_id'], ['employee_code', 'branch_id']);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function scopeCheckIns($query)
    {
        return $query->where('type', 'check_in');
    }

    public function scopeCheckOuts($query)
    {
        return $query->where('type', 'check_out');
    }

    public function scopeFromDevice($query)
    {
        return $query->where('source', 'device');
    }

    public function scopeFromHome($query)
    {
        return $query->where('source', 'home');
    }
}