<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contact extends Model
{
    use HasFactory;

    protected $table = 'contact';

    protected $fillable = [
        'action_time', 'session_started_at', 'geo_ip', 'geo_country',
        'geo_city', 'geo_region', 'geo_lat', 'geo_lon', 'geo_source',
        'platform', 'user_agent_sample', 'user_name', 'user_email',
        'user_mobile', 'user_services'
    ];

    protected $casts = [
        'action_time' => 'datetime',
        'session_started_at' => 'datetime',
        'geo_lat' => 'decimal:7',
        'geo_lon' => 'decimal:7',
    ];
}
