<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Department extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name','code','parent_id','manager_id','color_code','is_active','path','depth'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'depth'     => 'integer',
    ];

    // علاقات
    public function parent()   { return $this->belongsTo(Department::class, 'parent_id'); }
    public function children() { return $this->hasMany(Department::class, 'parent_id'); }
    public function teamMembers(){ return $this->hasMany(TeamMember::class); }
    public function manager()  { return $this->belongsTo(TeamMember::class, 'manager_id'); }

    // سكوبس
    public function scopeRoots($q){ return $q->whereNull('parent_id'); }
    public function scopeActive($q){ return $q->where('is_active', true); }





    // jemy work start from here
    public function employees()
{
    return $this->hasMany(Employee::class);
}
}
