<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MediaLink extends Model
{
    use HasFactory;

    protected $fillable = [
        'domain',
        'default_language',
        'en_logo',
        'en_title',
        'en_colors',
        'en_social_media_links',
        'en_contact',
        'en_qr_code',
        'ar_logo',
        'ar_title',
        'ar_colors',
        'ar_social_media_links',
        'ar_contact',
        'ar_qr_code',
    ];

    protected $casts = [
        'en_colors' => 'array',
        'en_social_media_links' => 'array',
        'en_contact' => 'array',
        'ar_colors' => 'array',
        'ar_social_media_links' => 'array',
        'ar_contact' => 'array',
    ];
}
