<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PerformanceLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_code',
        'branch_id',
        'check_time',
        'hours_worked',
        'status',
        'notes'
    ];

    protected $casts = [
        'check_time' => 'date',
        'hours_worked' => 'decimal:2',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class, ['employee_code', 'branch_id'], ['employee_code', 'branch_id']);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function scopeByEmployee($query, $employeeCode, $branchId)
    {
        return $query->where('employee_code', $employeeCode)
                    ->where('branch_id', $branchId);
    }

    public function scopeByStatus($query, $status)
    {
        return $query->where('status', $status);
    }

    public function scopeByDateRange($query, $startDate, $endDate)
    {
        return $query->whereBetween('check_time', [$startDate, $endDate]);
    }
}