<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quotation extends Model
{
    use HasFactory;

    CONST QuotationType = [
        'SHOPIFY' => 1,
        'LANDING' => 2,
        'SALLA' => 3,
        'WEBSITE' => 4,
        'WOOCOMMERCE' => 5,
    ];

    protected $fillable = [
        'subdomain',
        'type',
        'json_data',
    ];

    protected $casts = [
        'json_data' => 'array',
    ];
}
