<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Team extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name','type','account_manager_id','start_date','end_date','is_active'
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date'   => 'date',
        'is_active'  => 'boolean',
    ];

    public function accountManager(){ return $this->belongsTo(TeamMember::class, 'account_manager_id'); }
    public function memberships(){ return $this->hasMany(TeamMembership::class); }
    public function members(){
        return $this->belongsToMany(TeamMember::class, 'team_memberships')
            ->withPivot(['role_in_team','joined_at','left_at','is_active'])
            ->withTimestamps();
    }

    public function scopeActive($q){ return $q->where('is_active', true); }
}
