<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TeamMember extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'employee_code','first_name','last_name','name','role','department_id',
        'manager_id','email','phone','hire_date','status'
    ];

    protected $casts = [
        'hire_date' => 'date',
    ];

    // علاقات
    public function department(){ return $this->belongsTo(Department::class); }
    public function manager(){ return $this->belongsTo(TeamMember::class, 'manager_id'); }
    public function reports(){ return $this->hasMany(TeamMember::class, 'manager_id'); }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function teams(){
        return $this->belongsToMany(Team::class, 'team_memberships')
            ->withPivot(['role_in_team','joined_at','left_at','is_active'])
            ->withTimestamps();
    }

    // خصائص مساعدة
    public function getFullNameAttribute(){
        $full = trim(($this->first_name ?: '').' '.($this->last_name ?: ''));
        return $full !== '' ? $full : ($this->name ?: $this->employee_code);
    }

    // سكوبس
    public function scopeActive($q){ return $q->where('status','active'); }

    // app/Models/TeamMember.php
public function memberships()  { return $this->hasMany(TeamMembership::class); }


}
