<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TeamMembership extends Model
{
    use HasFactory;

    protected $fillable = [
        'team_id','team_member_id','role_in_team','joined_at','left_at','is_active'
    ];

    protected $casts = [
        'joined_at' => 'date',
        'left_at'   => 'date',
        'is_active' => 'boolean',
    ];

    public function team(){ return $this->belongsTo(Team::class); }
    public function member(){ return $this->belongsTo(TeamMember::class, 'team_member_id'); }
}
