<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use App\Models\Attendance;
use App\Models\Company;
use App\Models\Employee;
use App\Models\TeamMember;
use App\Models\Department;


class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable , HasRoles;
    protected $guard_name = 'web';
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
     protected $fillable = [
        'name','email','password','mobile','avatar','company_id','created_by',
        'status','imap_username','imap_password_encrypted','email_verified_at',
    ];

    protected $hidden = [
        'password',
        'remember_token',
        'imap_password_encrypted'
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'status' => 'integer',
    ];



    public function attendances()
    {
        return $this->hasMany(Attendance::class);
    }



    public function company()   { return $this->belongsTo(Company::class); }
    public function creator()   { return $this->belongsTo(User::class,'created_by'); }
    public function employee()  { return $this->hasOne(Employee::class); }


    // فرق المستخدم عبر الملف الوظيفي + العضويات
    public function teams() {
        return $this->hasManyThrough(
            Team::class,
            TeamMembership::class,
            'team_member_id', // FK on memberships to TeamMember
            'id',             // FK on Team
            'id',             // Local key on User
            'team_id'         // Local key on Memberships
        )->whereHas('members', fn($q) => $q->where('team_members.user_id', $this->id));
    }

    public function isTeamLeadOfDepartment($departmentId = null)
    {
        if (!$this->hasRole('Team Lead')) {
            return false;
        }

        $employee = $this->employee;
        if (!$employee) {
            return false;
        }

        if ($departmentId) {
            return $employee->department_id == $departmentId;
        }

        return true; // Has Team Lead role and is in a department
    }

    public function getManagedDepartments()
    {
        if (!$this->hasRole('Team Lead')) {
            return collect();
        }

        $employee = $this->employee;
        if (!$employee) {
            return collect();
        }

        return Department::where('id', $employee->department_id)->get();
    }

}

