<?php

namespace App\Models;

use App\Enums\VacationStatus;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Vacation extends Model
{
    protected $fillable = [
        'employee_id',
        'vacation_type_id',
        'start_date',
        'end_date',
        'total_days',
        'member_reason',
        'leader_reason',
        'hr_reason',
        'status',
        'needs_hr',
        'requested_by_user_id',
        'leader_approved_by_user_id',
        'hr_approved_by_user_id,leader_decision_at',
        'hr_decision_at'
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date'   => 'date',
        'status'     => VacationStatus::class,
        'needs_hr'   => 'boolean',
        'leader_decision_at' => 'datetime',
        'hr_decision_at'     => 'datetime',
    ];

    // الجديد: الربط بالموظف (الأساس)
    public function employee(): BelongsTo
    {
        return $this->belongsTo(Employee::class);
    }

    // النوع
    public function type(): BelongsTo
    {
        return $this->belongsTo(VacationType::class, 'vacation_type_id');
    }

    // الـ actors (يوزرز)
    public function requestedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'requested_by_user_id');
    }
    public function leaderApprovedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'leader_approved_by_user_id');
    }
    public function hrApprovedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'hr_approved_by_user_id');
    }
}
