<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class VacationType extends Model
{
    protected $fillable = [
        'name','code','required_approvals','deducts_balance',
        'max_days_per_request','max_days_per_year','weekend_excluded'
    ];

    public function vacations(): HasMany {
        return $this->hasMany(Vacation::class);
    }
}
