<?php

namespace App\Policies;

use App\Models\Employee;
use App\Models\User;

class EmployeePolicy
{
    // أي حد عنده employees.view يقدر يشوف حسب القيود
    public function view(User $user, Employee $employee): bool
    {
        // Admin/HR يشوفوا الكل
        if ($user->hasAnyRole(['Admin','HR'])) return true;

        // Manager يشوف موظفين قسمه
        if ($user->hasRole('Manager') && $user->employee && $employee->department_id) {
            return $user->employee->department_id === $employee->department_id;
        }

        // Employee يشوف نفسه فقط
        if ($user->hasRole('Employee') && $user->employee) {
            return $user->employee->id === $employee->id;
        }

        return false;
    }

    public function create(User $user): bool
    {
        return $user->hasAnyRole(['Admin','HR']);
    }

    public function update(User $user, Employee $employee): bool
    {
        if ($user->hasAnyRole(['Admin','HR'])) return true;

        // Manager يحدّث موظفين قسمه فقط
        if ($user->hasRole('Manager') && $user->employee) {
            return $user->employee->department_id === $employee->department_id;
        }

        // Employee يقدر يعدّل ملفه الشخصي؟ غالبًا لا — لو عايز تسمح له ببعض الحقول، اعمل gate تاني
        return false;
    }

    public function delete(User $user, Employee $employee): bool
    {
        return $user->hasAnyRole(['Admin','HR']);
    }
}
