<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;
use App\Models\AttendancePermit;
use App\Policies\AttendancePermitPolicy;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
        \App\Models\Employee::class => \App\Policies\EmployeePolicy::class,
        \App\Models\Vacation::class => \App\Policies\VacationPolicy::class,
        \App\Models\AttendancePermit::class => \App\Policies\AttendancePermitPolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();
    }
}
