<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Laravel\Telescope\IncomingEntry;
use Laravel\Telescope\Telescope;
use Laravel\Telescope\TelescopeApplicationServiceProvider;

class TelescopeServiceProvider extends TelescopeApplicationServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        Telescope::night(); // Enable dark theme

        $this->hideSensitiveRequestDetails();

        // Record everything
        Telescope::filter(function (IncomingEntry $entry) {
            return true;
        });

        // Tag all entries for better filtering
        Telescope::tag(function (IncomingEntry $entry) {
            return ['env:' . app()->environment()];
        });
    }

    /**
     * Prevent sensitive request details from being logged by Telescope.
     */
    protected function hideSensitiveRequestDetails(): void
    {
        Telescope::hideRequestParameters(['_token', 'password', 'password_confirmation']);
        Telescope::hideRequestHeaders(['cookie', 'x-csrf-token', 'x-xsrf-token']);
    }

    /**
     * Register the Telescope gate.
     */
    protected function gate(): void
    {
        Gate::define('viewTelescope', function ($user = null) {
            return true; // Allow public access
        });
    }

    /**
     * Get the email address that should receive the exception notifications.
     */
    protected function getEmail(): ?string
    {
        return null; // Disable email notifications for now
    }
}
