<?php

namespace App\Services;

use Illuminate\Support\Facades\Storage;
use App\Models\User;

class AvatarService
{
    public function updateUserAvatar(User $user, $avatarFile)
    {
        $oldAvatar = $user->avatar;

        $path = $avatarFile->store('avatars', 'public');

        $user->update(['avatar' => $path]);

        if ($oldAvatar && Storage::disk('public')->exists($oldAvatar)) {
            Storage::disk('public')->delete($oldAvatar);
        }

        return $path;
    }
}