<?php

namespace App\Services;

use Carbon\CarbonImmutable;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use RuntimeException;

class HomeAttendanceService
{
    public function checkIn(): array
    {
        $user = Auth::user();
        if (!$user || !$user->employee?->employee_code) {
            throw new RuntimeException('Employee mapping not found for user.');
        }

        $now = CarbonImmutable::now('Africa/Cairo');

        // ممنوع check-in جديد لو آخر حدث اليوم هو check_in بلا out
        $open = DB::table('attendance_logs')
            ->where('employee_code', $user->employee->employee_code)
            ->whereDate('check_time', $now->toDateString())
            ->whereIn('type', ['check_in', 'check_out'])
            ->orderByDesc('check_time')
            ->first();

        if ($open && $open->type === 'check_in') {
            return ['ok' => false, 'msg' => 'Already checked in. Please check out first.'];
        }

        DB::table('attendance_logs')->insertOrIgnore([[
            'employee_code' => $user->employee->employee_code,
            'branch_id'     => $user->employee->branch_id ?? null,
            'check_time'    => $now,                 // tz safe
            'type'          => 'check_in',
            'source'        => 'home',
            'employee_name' => $user->name,
            'branch_name'   => null,
            'created_at'    => now(),
            'updated_at'    => now(),
        ]]);

        return ['ok' => true, 'when' => $now->toDateTimeString()];
    }

    public function checkOut(): array
    {
        $user = Auth::user();
        if (!$user || !$user->employee?->employee_code) {
            throw new RuntimeException('Employee mapping not found for user.');
        }

        $now = CarbonImmutable::now('Africa/Cairo');

        // لازم يكون في check_in مفتوح بنفس اليوم
        $lastIn = DB::table('attendance_logs')
            ->where('employee_code', $user->employee->employee_code)
            ->whereDate('check_time', $now->toDateString())
            ->where('type', 'check_in')
            ->orderByDesc('check_time')
            ->first();

        $lastOut = DB::table('attendance_logs')
            ->where('employee_code', $user->employee->employee_code)
            ->whereDate('check_time', $now->toDateString())
            ->where('type', 'check_out')
            ->orderByDesc('check_time')
            ->first();

        if (!$lastIn || ($lastOut && $lastOut->check_time > $lastIn->check_time)) {
            return ['ok' => false, 'msg' => 'No active check-in found for today.'];
        }

        DB::table('attendance_logs')->insertOrIgnore([[
            'employee_code' => $user->employee->employee_code,
            'branch_id'     => $user->employee->branch_id ?? null,
            'check_time'    => $now,
            'type'          => 'check_out',
            'source'        => 'home',
            'employee_name' => $user->name,
            'branch_name'   => null,
            'created_at'    => now(),
            'updated_at'    => now(),
        ]]);

        return ['ok' => true, 'when' => $now->toDateTimeString()];
    }
}
