<?php

namespace App\Services;

use App\Models\Team;
use App\Models\TeamMember;

class TeamService
{
    public function getAllTeams()
    {
        return Team::with('accountManager')->get();
    }

    public function createTeam(array $data): Team
    {
        return Team::create($data);
    }

    public function getTeamById(int $id): Team
    {
        return Team::with('members')->findOrFail($id);
    }

    public function updateTeam(Team $team, array $data): Team
    {
        $team->update($data);
        return $team;
    }

    public function deleteTeam(Team $team): void
    {
        $team->delete();
    }

    public function attachMember(Team $team, int $teamMemberId, array $pivotData): void
    {
        $team->members()->attach($teamMemberId, $pivotData);
    }

    public function detachMember(Team $team, int $teamMemberId): void
    {
        $team->members()->detach($teamMemberId);
    }
}
