<?php

namespace App\Support;

use Illuminate\Support\Facades\Crypt;
use Illuminate\Contracts\Encryption\DecryptException;

class Sec
{
    /** Encrypt a string (null-safe) */
    public static function enc(?string $plain): ?string
    {
        return $plain !== null ? Crypt::encryptString($plain) : null;
    }

    /** Decrypt a string (null-safe + guarded) */
    public static function dec(?string $cipher): ?string
    {
        if ($cipher === null) return null;

        try {
            return Crypt::decryptString($cipher);
        } catch (DecryptException $e) {
            // متفكّتش لسبب ما (مفتاح اتغير.. إلخ) — رجّع null وسجّل الخطأ بدون أسرار
            report($e);
            return null;
        }
    }
}
