<?php

return [
    'weekend_days' => ['fri', 'sat'], // اختصار أيام: sun, mon, tue, wed, thu, fri, sat

    // حد شهري بالدقايق/المرات لكل نوع إذن (اختياري)
    // أمثلة: short_leave = 240 دقيقة/شهر (4 ساعات)، early_exit = 2 مرات/شهر
    'monthly_limits' => [
        // بالدقائق
        'minutes' => [
            'short_leave' => 240,
            'medical'     => 480,
        ],
        // بعدد الطلبات
        'count' => [
            'early_exit'  => 2,
            'late_entry'  => 3,
        ],
    ],

    // لو عايز تمنع تمامًا في الويك إند/العطلات
    'block_weekends' => true,
    'block_holidays' => true,


    'vacations' => [
        'needs_hr_if_days_over' => 5,
        'types_need_hr' => ['unpaid', 'sick_long'],
    ],
    'permits' => [
        'needs_hr_if_minutes_over' => 120,
        'outside_working_hours_needs_hr' => true,
        'monthly_repeat_threshold' => 3, // بعد 3 أذونات متشابهة خلال شهر
    ],
];
