<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Profile Navigation Tabs Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains the configuration for dynamic profile navigation tabs.
    | You can easily add, remove, or modify tabs here for better scalability.
    |
    */

    'tabs' => [
        'attendance' => [
            'label' => 'My Attendance',
            'icon' => 'fas fa-clock',
            'permissions' => ['*'], // All roles can access
            'enabled' => true,
            'order' => 1,
            'css_class' => '',
            'link_class' => '',
            'value_class' => 'text-success',
            'tooltip' => 'View your attendance records',
            'show_badge' => true,
            'badge_type' => 'notification', // notification, status, count
            'url_route' => null, // Optional custom route
            'ajax_load' => false,
            'trend_enabled' => true,
        ],
        'messages' => [
            'label' => 'Messages',
            'icon' => 'fas fa-envelope',
            'permissions' => ['admin', 'manager', 'employee'],
            'enabled' => false, // Can be toggled on/off
            'order' => 2,
            'css_class' => '',
            'link_class' => '',
            'value_class' => '',
            'tooltip' => 'Check your messages',
            'show_badge' => true,
            'badge_type' => 'count',
            'url_route' => 'profile.messages',
            'ajax_load' => true,
            'trend_enabled' => false,
        ],
        'team' => [
            'label' => 'My Team',
            'icon' => 'fas fa-users',
            'permissions' => ['admin', 'manager'],
            'enabled' => false,
            'order' => 3,
            'css_class' => '',
            'link_class' => '',
            'value_class' => 'text-info',
            'tooltip' => 'Manage your team',
            'show_badge' => false,
            'badge_type' => 'count',
            'url_route' => null,
            'ajax_load' => false,
            'trend_enabled' => false,
        ],
        'announcements' => [
            'label' => 'Announcements',
            'icon' => 'fas fa-bullhorn',
            'permissions' => ['*'],
            'enabled' => false,
            'order' => 4,
            'css_class' => '',
            'link_class' => '',
            'value_class' => 'text-warning',
            'tooltip' => 'View company announcements',
            'show_badge' => true,
            'badge_type' => 'notification',
            'url_route' => null,
            'ajax_load' => false,
            'trend_enabled' => false,
        ],
        'performance' => [
            'label' => 'My Performance',
            'icon' => 'fas fa-chart-line',
            'permissions' => ['*'],
            'enabled' => true,
            'order' => 5,
            'css_class' => '',
            'link_class' => '',
            'value_class' => 'text-primary fw-bold',
            'tooltip' => 'View your performance metrics',
            'show_badge' => false,
            'badge_type' => 'status',
            'url_route' => null,
            'ajax_load' => false,
            'trend_enabled' => true,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Active Tab
    |--------------------------------------------------------------------------
    |
    | This determines which tab should be active by default when the page loads.
    |
    */
    'default_active' => 'attendance',

    /*
    |--------------------------------------------------------------------------
    | Tab Display Options
    |--------------------------------------------------------------------------
    |
    | Configure how tabs are displayed
    |
    */
    'display' => [
        'show_icons' => true,
        'show_values' => true,
        'max_tabs' => 10, // Maximum number of tabs to display
    ],

];
